from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.monitoring import MonitoringSettings
from app.v1.services.platform import monitoring as monitoring_service

router = APIRouter()

@router.get("/", response_model=MonitoringSettings)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return monitoring_service.get_monitoring_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=MonitoringSettings)
def update_settings(account_id: str,settings: MonitoringSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return monitoring_service.update_monitoring_settings(account_id, settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
